#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BloodTestBase : BaseTest 
	{

		private DataTable _dtBloodUnitTest;
		private BOL.BloodTestBase _testBloodTestBase;
		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtBloodUnitTest = UnitTestUtil.RunSQLGetDataTable(" SELECT TOP 1 * FROM BloodUnitTest WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}

			this._testBloodTestBase = new BOL.BloodTestBase();
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.BloodTestBase tmpObj = new BOL.BloodTestBase();
			Assert.IsNotNull(tmpObj);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			DataRow dr = this._dtBloodUnitTest.Rows[0];
			BOL.BloodTestBase tmpObj = new BOL.BloodTestBase(dr);

			if (!dr.IsNull(TABLES.BloodUnitTest.BloodUnitTestGuid))
				Assert.IsTrue(tmpObj.BloodUnitTestGuid == (System.Guid)dr[TABLES.BloodUnitTest.BloodUnitTestGuid]);

			if (!dr.IsNull(TABLES.BloodUnitTest.TestComments))
				Assert.IsTrue(tmpObj.TestComments == dr[TABLES.BloodUnitTest.TestComments].ToString());

			if (!dr.IsNull(TABLES.BloodUnitTest.TestDate))
				Assert.IsTrue(tmpObj.TestDate == (System.DateTime)dr[TABLES.BloodUnitTest.TestDate]);

			if (!dr.IsNull(TABLES.BloodUnitTest.TestResultId))
				Assert.IsTrue(tmpObj.TestResultId == dr[TABLES.BloodUnitTest.TestResultId].ToString());

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void BloodUnitTestGuid_Pass()
		{
			System.Guid tmpValue = System.Guid.NewGuid();

			this._testBloodTestBase.BloodUnitTestGuid = tmpValue;
			Assert.IsTrue(this._testBloodTestBase.BloodUnitTestGuid == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitTestGuid_Fail()
		{
		}

		[Test]
		public void BloodTestTypeObj_Pass()
		{
			BOL.BloodTestType tmpObj = new BOL.BloodTestType((int)Common.TestType.AntiB);

			this._testBloodTestBase.BloodTestTypeObj = tmpObj;
			Assert.IsTrue(this._testBloodTestBase.BloodTestTypeObj == tmpObj);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodTestTypeObj_Fail()
		{
		}

		[Test]
		public void TestDate_Pass()
		{
			System.DateTime tmpValue = System.DateTime.Now;

			this._testBloodTestBase.TestDate = tmpValue;
			Assert.IsTrue(this._testBloodTestBase.TestDate == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestDate_Fail()
		{
		}

		[Test]
		public void TestResultId_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();
			this._testBloodTestBase.TestResultId = tmpValue;
			Assert.IsTrue(this._testBloodTestBase.TestResultId == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestResultId_Fail()
		{
		}

		[Test]
		public void TestComments_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();
			this._testBloodTestBase.TestComments = tmpValue;
			Assert.IsTrue(this._testBloodTestBase.TestComments == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestComments_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr = this._dtBloodUnitTest.Rows[0];
			BOL.BloodTestBase tmpObj = new BOL.BloodTestBase(dr);
			
			Assert.IsTrue((System.Guid)dr[TABLES.BloodUnitTest.BloodUnitTestGuid] == tmpObj.BloodUnitTestGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

	}
}

#endif




